/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Quicksilver
extends AbstractCard {
    public static final String ID = "Quicksilver";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Quicksilver");
    public static final String NAME = "Quicksilver";
    public static final String DESCRIPTION = "Deal !D! damage. Draw !M! card(s).";
    private static final int COST = 1;
    private static final int DAMAGE_AMT = 4;
    private static final int CARD_DRAW_AMT = 1;
    private static final int POOL = 1;

    public Quicksilver() {
        super("Quicksilver", "Quicksilver", null, 1, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ENEMY, 1);
        this.subType = AbstractCard.CardSubType.AMMO;
        this.baseDamage = 4;
        this.magicNumber = this.baseMagicNumber = 1;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
        AbstractDungeon.actionManager.addToBottom(new DrawCardAction(p, this.magicNumber));
    }

    @Override
    public void fire(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m);
    }

    @Override
    public AbstractCard makeCopy() {
        return new Quicksilver();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
        }
    }
}

